GO
IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_TELE_ORC_END_ENTR_RC_CLI')
begin
	DROP TRIGGER [dbo].[TRG_TELE_ORC_END_ENTR_RC_CLI]
end
go

CREATE TRIGGER [dbo].[TRG_TELE_ORC_END_ENTR_RC_CLI] ON [dbo].[TELE_ORC] FOR 
INSERT AS
begin

	begin try
		DECLARE @REG INT
		DECLARE @CD_CLI INT
		SELECT @CD_CLI =I.CD_CLI FROM INSERTED I
		SELECT @REG = COUNT(1)
		FROM TELE_ORC_END_ENTR_RC_CLI VTE INNER JOIN
			 TELE_ORC TLO ON
				TLO.CD_ORC = VTE.CD_ORC AND
				TLO.CD_CLI = VTE.CD_CLI INNER JOIN
			 INSERTED I ON
              TLO.ENT_CEP = I.ENT_CEP AND
			  TLO.ENT_COMPLEMENTO = I.ENT_COMPLEMENTO AND
			  TLO.ENT_REFENTREGA = I.ENT_REFENTREGA AND
			  TLO.CD_CLI=I.CD_CLI 

		IF @REG = 0
			BEGIN
				SELECT @REG = COUNT(1) FROM (SELECT A.CEP,
					   B.DS_CID_LOGRA+', '+B.BAIRRO AS ENDERECO,
					   COMPLEMENTO, 
					   PONTO_REF , 
					   -1 as ORC,
					   B.CD_CID_LOGRA
				  FROM RC_CLI A INNER JOIN 
					   GLB_CID_LOGRA B ON 
						  B.CEP = A.CEP_RESIDENCIAL COLLATE SQL_Latin1_General_CP1_CI_AS INNER JOIN
					   GLB_CID C ON 
						  C.CD_CID = B.CD_CID
				 WHERE CD_CLI = @CD_CLI
				UNION
				SELECT A.CEP,
					   B.DS_CID_LOGRA+', '+B.BAIRRO,
					   COMPLEMENTO, 
					   PONTO_REF , 
					   -1,
					   B.CD_CID_LOGRA
				  FROM RC_CLI A INNER JOIN 
					   GLB_CID_LOGRA B ON 
						  B.CEP = A.CEP COLLATE SQL_Latin1_General_CP1_CI_AS INNER JOIN
					   GLB_CID C ON 
						  C.CD_CID = B.CD_CID
				 WHERE CD_CLI = @CD_CLI
				 UNION
				 SELECT B.CEP COLLATE SQL_Latin1_General_CP1_CI_AS,
						B.DS_CID_LOGRA+', '+B.BAIRRO,
						A.END_CPL,
						A.PONTO_REF,
						-1,
						B.CD_CID_LOGRA
				   FROM RC_CLI_ENTR A INNER JOIN
						GLB_CID_LOGRA B ON
						   B.CD_CID_LOGRA = A.CD_CID_LOGRA
				  WHERE CD_CLI = @CD_CLI) AS L INNER JOIN 
				  INSERTED I ON
				    I.CD_CID_LOGRA = L.CD_CID_LOGRA AND 
				    I.ENT_COMPLEMENTO = L.COMPLEMENTO COLLATE SQL_Latin1_General_CP1_CI_AS AND 
				    I.ENT_REFENTREGA = L.PONTO_REF COLLATE SQL_Latin1_General_CP1_CI_AS
			END

		IF @REG = 0
		INSERT INTO TELE_ORC_END_ENTR_RC_CLI SELECT I.CD_EMP, I.CD_CLI, I.CD_ORC FROM INSERTED I
	end try
	
	begin catch
		RAISERROR ('Erro na trigger TRG_TELE_ORC_END_ENTR_RC_CLI.',16, 1); 
		RETURN;	
	end catch

end
GO



